/*
International Telephone Input v3.3.0
https://github.com/Bluefieldscom/intl-tel-input.git
*/
!function(a){"function"==typeof define&&define.amd?define(["jquery"],function(b){a(b,window,document)}):a(jQuery,window,document)}(function(a,b,c,d){"use strict";function e(b,c){this.element=b,this.options=a.extend({},h,c),this._defaults=h,this.ns="."+f+g++,this.isGoodBrowser=Boolean(b.setSelectionRange),this.hadInitialPlaceholder=Boolean(a(b).attr("placeholder")),this._name=f,this.init()}var f="intlTelInput",g=1,h={autoFormat:!0,autoHideDialCode:!0,defaultCountry:"",nationalMode:!1,onlyCountries:[],preferredCountries:["us","gb"],responsiveDropdown:!1,utilsScript:""},i={UP:38,DOWN:40,ENTER:13,ESC:27,PLUS:43,A:65,Z:90,ZERO:48,NINE:57,SPACE:32,BSPACE:8,DEL:46,CTRL:17,CMD1:91,CMD2:224},j=!1;a(b).load(function(){j=!0}),e.prototype={init:function(){var b=this;"auto"==this.options.defaultCountry?a.get("http://ipinfo.io",function(a){b.options.defaultCountry=a&&a.country?a.country.toLowerCase():"",b.ready()},"jsonp"):this.ready()},ready:function(){this.options.nationalMode&&(this.options.autoHideDialCode=!1),(navigator.userAgent.match(/IEMobile/i)||navigator.userAgent.match(/Android/i)&&navigator.userAgent.match(/Chrome/i))&&(this.options.autoFormat=!1),b.innerWidth<500&&(this.options.responsiveDropdown=!0),this._processCountryData(),this._generateMarkup(),this._setInitialState(),this._initListeners()},_processCountryData:function(){this._setInstanceCountryData(),this._setPreferredCountries()},_addCountryCode:function(a,b,c){b in this.countryCodes||(this.countryCodes[b]=[]);var d=c||0;this.countryCodes[b][d]=a},_setInstanceCountryData:function(){var a;if(this.options.onlyCountries.length)for(this.countries=[],a=0;a<this.options.onlyCountries.length;a++){var b=this._getCountryData(this.options.onlyCountries[a],!0,!1);b&&this.countries.push(b)}else this.countries=k;for(this.countryCodes={},a=0;a<this.countries.length;a++){var c=this.countries[a];if(this._addCountryCode(c.iso2,c.dialCode,c.priority),c.areaCodes)for(var d=0;d<c.areaCodes.length;d++)this._addCountryCode(c.iso2,c.dialCode+c.areaCodes[d])}},_setPreferredCountries:function(){this.preferredCountries=[];for(var a=0;a<this.options.preferredCountries.length;a++){var b=this.options.preferredCountries[a],c=this._getCountryData(b,!1,!0);c&&this.preferredCountries.push(c)}},_generateMarkup:function(){this.telInput=a(this.element),this.telInput.wrap(a("<div>",{"class":"intl-tel-input"}));var b=a("<div>",{"class":"flag-dropdown"}).insertAfter(this.telInput),c=a("<div>",{"class":"selected-flag"}).appendTo(b);this.selectedFlagInner=a("<div>",{"class":"flag"}).appendTo(c),a("<div>",{"class":"arrow"}).appendTo(this.selectedFlagInner),this.countryList=a("<ul>",{"class":"country-list v-hide"}).appendTo(b),this.preferredCountries.length&&(this._appendListItems(this.preferredCountries,"preferred"),a("<li>",{"class":"divider"}).appendTo(this.countryList)),this._appendListItems(this.countries,""),this.dropdownHeight=this.countryList.outerHeight(),this.countryList.removeClass("v-hide").addClass("hide"),this.options.responsiveDropdown&&this.countryList.outerWidth(this.telInput.outerWidth()),this.countryListItems=this.countryList.children(".country")},_appendListItems:function(a,b){for(var c="",d=0;d<a.length;d++){var e=a[d];c+="<li class='country "+b+"' data-dial-code='"+e.dialCode+"' data-country-code='"+e.iso2+"'>",c+="<div class='flag "+e.iso2+"'></div>",c+="<span class='country-name'>"+e.name+"</span>",c+="<span class='dial-code'>+"+e.dialCode+"</span>",c+="</li>"}this.countryList.append(c)},_setInitialState:function(){var a=this.telInput.val();if(this._getDialCode(a))this._updateFlagFromNumber(a);else{var b;b=this.options.defaultCountry?this._getCountryData(this.options.defaultCountry,!1,!1):this.preferredCountries.length?this.preferredCountries[0]:this.countries[0],this._selectFlag(b.iso2),a||this._resetToDialCode(b.dialCode)}a&&this._updateVal(a,!1)},_initListeners:function(){var c=this;this.options.autoHideDialCode&&this._initAutoHideDialCode();var d=this.telInput.closest("label");d.length&&d.on("click"+this.ns,function(a){c.countryList.hasClass("hide")?c.telInput.focus():a.preventDefault()}),this.options.autoFormat&&this.telInput.on("keypress"+this.ns,function(a){if(a.which>=i.SPACE&&!a.metaKey){a.preventDefault();var b=a.which>=i.ZERO&&a.which<=i.NINE||a.which==i.PLUS,d=c.telInput[0],e=c.isGoodBrowser&&d.selectionStart==d.selectionEnd,f=c.telInput.attr("maxlength"),g=f?c.telInput.val().length<f:!0;if(g&&(b||e)){var h=b?String.fromCharCode(a.which):null;c._handleInputKey(h,!0)}}}),this.telInput.on("keyup"+this.ns,function(a){if(a.which==i.ENTER);else if(c.options.autoFormat){var b=a.which==i.CTRL||a.which==i.CMD1||a.which==i.CMD2,d=c.telInput[0],e=c.isGoodBrowser&&d.selectionStart==d.selectionEnd,f=c.isGoodBrowser&&d.selectionStart==c.telInput.val().length;if(a.which==i.DEL||a.which==i.BSPACE||b&&e){var g=!(a.which==i.BSPACE&&f);c._handleInputKey(null,g)}if(!c.options.nationalMode){var h=c.telInput.val();if("+"!=h.substr(0,1)){var j=c.isGoodBrowser?d.selectionStart+1:0;c.telInput.val("+"+h),c.isGoodBrowser&&d.setSelectionRange(j,j)}}}else c._updateFlagFromNumber(c.telInput.val())});var e=this.selectedFlagInner.parent();e.on("click"+this.ns,function(){c.countryList.hasClass("hide")&&!c.telInput.prop("disabled")&&c._showDropdown()}),this.options.utilsScript&&(j?this.loadUtils():a(b).load(function(){c.loadUtils()}))},_handleInputKey:function(a,b){var c=this.telInput.val(),d=null,e=!1,f=this.telInput[0];if(this.isGoodBrowser){var g=f.selectionEnd,h=c.length;e=g==h,a?(c=c.substring(0,f.selectionStart)+a+c.substring(g,h),e||(d=g+(c.length-h))):d=f.selectionStart}else a&&(c+=a);this.setNumber(c,b),this.isGoodBrowser&&(e&&(d=this.telInput.val().length),f.setSelectionRange(d,d))},_initAutoHideDialCode:function(){var a=this;this.telInput.on("mousedown"+this.ns,function(b){a.telInput.is(":focus")||a.telInput.val()||(b.preventDefault(),a.telInput.focus())}),this.telInput.on("focus"+this.ns,function(){a.telInput.val()||(a._updateVal("+"+a.selectedCountryData.dialCode,!0),a.telInput.one("keypress.plus"+a.ns,function(b){if(b.which==i.PLUS){var c=a.options.autoFormat?"+":"";a.telInput.val(c)}}),setTimeout(function(){var b=a.telInput[0];if(a.isGoodBrowser){var c=a.telInput.val().length;b.setSelectionRange(c,c)}}))}),this.telInput.on("blur"+this.ns,function(){var b=a.telInput.val(),c="+"==b.substr(0,1);if(c){var d=a._getNumeric(b);d&&a.selectedCountryData.dialCode!=d||a.telInput.val("")}a.telInput.off("keypress.plus"+a.ns)})},_getNumeric:function(a){return a.replace(/\D/g,"")},_showDropdown:function(){this._setDropdownPosition();var a=this.countryList.children(".active");this._highlightListItem(a),this.countryList.removeClass("hide"),this._scrollTo(a),this._bindDropdownListeners(),this.selectedFlagInner.children(".arrow").addClass("up")},_setDropdownPosition:function(){var c=this.telInput.offset().top,d=a(b).scrollTop(),e=c+this.telInput.outerHeight()+this.dropdownHeight<d+a(b).height(),f=c-this.dropdownHeight>d,g=!e&&f?"-"+(this.dropdownHeight-1)+"px":"";this.countryList.css("top",g)},_bindDropdownListeners:function(){var b=this;this.countryList.on("mouseover"+this.ns,".country",function(){b._highlightListItem(a(this))}),this.countryList.on("click"+this.ns,".country",function(){b._selectListItem(a(this))});var d=!0;a("html").on("click"+this.ns,function(){d||b._closeDropdown(),d=!1});var e="",f=null;a(c).on("keydown"+this.ns,function(a){a.preventDefault(),a.which==i.UP||a.which==i.DOWN?b._handleUpDownKey(a.which):a.which==i.ENTER?b._handleEnterKey():a.which==i.ESC?b._closeDropdown():(a.which>=i.A&&a.which<=i.Z||a.which==i.SPACE)&&(f&&clearTimeout(f),e+=String.fromCharCode(a.which),b._searchForCountry(e),f=setTimeout(function(){e=""},1e3))})},_handleUpDownKey:function(a){var b=this.countryList.children(".highlight").first(),c=a==i.UP?b.prev():b.next();c.length&&(c.hasClass("divider")&&(c=a==i.UP?c.prev():c.next()),this._highlightListItem(c),this._scrollTo(c))},_handleEnterKey:function(){var a=this.countryList.children(".highlight").first();a.length&&this._selectListItem(a)},_searchForCountry:function(a){for(var b=0;b<this.countries.length;b++)if(this._startsWith(this.countries[b].name,a)){var c=this.countryList.children("[data-country-code="+this.countries[b].iso2+"]").not(".preferred");this._highlightListItem(c),this._scrollTo(c,!0);break}},_startsWith:function(a,b){return a.substr(0,b.length).toUpperCase()==b},_updateVal:function(a,c){var d;if(this.options.autoFormat&&b.intlTelInputUtils){d=intlTelInputUtils.formatNumber(a,this.selectedCountryData.iso2,c);var e=this.telInput.attr("maxlength");e&&d.length>e&&(d=d.substr(0,e))}else d=a;this.telInput.val(d)},_updateFlagFromNumber:function(a){var b=this._getDialCode(a);if(b){var c=this.countryCodes[this._getNumeric(b)],d=!1;if(this.selectedCountryData)for(var e=0;e<c.length;e++)c[e]==this.selectedCountryData.iso2&&(d=!0);if(!d||this._isUnknownNanp(a,b))for(var f=0;f<c.length;f++)if(c[f]){this._selectFlag(c[f]);break}}},_isUnknownNanp:function(a,b){return"+1"==b&&this._getNumeric(a).length>=4},_resetToDialCode:function(a){this.options.nationalMode||this.options.autoHideDialCode||this.telInput.val("+"+a)},_highlightListItem:function(a){this.countryListItems.removeClass("highlight"),a.addClass("highlight")},_getCountryData:function(a,b,c){for(var d=b?k:this.countries,e=0;e<d.length;e++)if(d[e].iso2==a)return d[e];if(c)return null;throw new Error("No country data for '"+a+"'")},_selectFlag:function(a){this.selectedCountryData=this._getCountryData(a,!1,!1),this.selectedFlagInner.attr("class","flag "+a);var b=this.selectedCountryData.name+": +"+this.selectedCountryData.dialCode;this.selectedFlagInner.parent().attr("title",b),this._updatePlaceholder();var c=this.countryListItems.children(".flag."+a).first().parent();this.countryListItems.removeClass("active"),c.addClass("active")},_updatePlaceholder:function(){if(b.intlTelInputUtils&&!this.hadInitialPlaceholder){var a=this.selectedCountryData.iso2,c=intlTelInputUtils.getExampleNumber(a,this.options.nationalMode);this.telInput.attr("placeholder",c)}},_selectListItem:function(a){var b=a.attr("data-country-code");this._selectFlag(b),this._closeDropdown(),this.options.nationalMode||this._updateDialCode("+"+a.attr("data-dial-code")),this.telInput.trigger("change"),this.telInput.focus()},_closeDropdown:function(){this.countryList.addClass("hide"),this.selectedFlagInner.children(".arrow").removeClass("up"),a(c).off(this.ns),a("html").off(this.ns),this.countryList.off(this.ns)},_scrollTo:function(a,b){var c=this.countryList,d=c.height(),e=c.offset().top,f=e+d,g=a.outerHeight(),h=a.offset().top,i=h+g,j=h-e+c.scrollTop(),k=d/2-g/2;if(e>h)b&&(j-=k),c.scrollTop(j);else if(i>f){b&&(j+=k);var l=d-g;c.scrollTop(j-l)}},_updateDialCode:function(b){var c,d=this.telInput.val(),e=this._getDialCode(d);if(e.length>1)c=d.replace(e,b);else{var f=d&&"+"!=d.substr(0,1)?a.trim(d):"";c=b+f}this._updateVal(c,!0)},_getDialCode:function(b){var c="";if("+"==b.charAt(0))for(var d="",e=0;e<b.length;e++){var f=b.charAt(e);if(a.isNumeric(f)&&(d+=f,this.countryCodes[d]&&(c=b.substring(0,e+1)),4==d.length))break}return c},destroy:function(){this._closeDropdown(),this.telInput.off(this.ns),this.selectedFlagInner.parent().off(this.ns),this.telInput.closest("label").off(this.ns);var a=this.telInput.parent();a.before(this.telInput).remove()},getCleanNumber:function(){return b.intlTelInputUtils?intlTelInputUtils.formatNumberE164(this.telInput.val(),this.selectedCountryData.iso2):""},getNumberType:function(){return b.intlTelInputUtils?intlTelInputUtils.getNumberType(this.telInput.val(),this.selectedCountryData.iso2):-99},getSelectedCountryData:function(){return this.selectedCountryData||{}},getValidationError:function(){return b.intlTelInputUtils?intlTelInputUtils.getValidationError(this.telInput.val(),this.selectedCountryData.iso2):-99},isValidNumber:function(){var c=a.trim(this.telInput.val()),d=this.options.nationalMode?this.selectedCountryData.iso2:"",e=/[a-zA-Z]/.test(c);return Boolean(!e&&b.intlTelInputUtils&&intlTelInputUtils.isValidNumber(c,d))},loadUtils:function(b){var c=b||this.options.utilsScript;!a.fn[f].loadedUtilsScript&&c&&(a.fn[f].loadedUtilsScript=!0,a.ajax({url:c,success:function(){a(".intl-tel-input input").intlTelInput("utilsLoaded")},dataType:"script",cache:!0}))},selectCountry:function(a){if(!this.selectedFlagInner.hasClass(a)){this._selectFlag(a);var b=this.telInput.val();b?this.options.nationalMode?this._updateVal(b):b&&this._updateDialCode("+"+this.selectedCountryData.dialCode):this._resetToDialCode(this.selectedCountryData.dialCode)}},setNumber:function(a,b){this.options.nationalMode||"+"==a.substr(0,1)||(a="+"+a),this._updateFlagFromNumber(a),this._updateVal(a,b)},utilsLoaded:function(){this.options.autoFormat&&this.telInput.val()&&this._updateVal(this.telInput.val()),this._updatePlaceholder()}},a.fn[f]=function(b){var c=arguments;if(b===d||"object"==typeof b)return this.each(function(){a.data(this,"plugin_"+f)||a.data(this,"plugin_"+f,new e(this,b))});if("string"==typeof b&&"_"!==b[0]&&"init"!==b){var g;return this.each(function(){var d=a.data(this,"plugin_"+f);d instanceof e&&"function"==typeof d[b]&&(g=d[b].apply(d,Array.prototype.slice.call(c,1))),"destroy"===b&&a.data(this,"plugin_"+f,null)}),g!==d?g:this}},a.fn[f].getCountryData=function(){return k},a.fn[f].setCountryData=function(a){k=a};for(var k=[["Afghanistan (‫افغانستان‬‎)","af","93"],["Albania (Shqipëri)","al","355"],["Algeria (‫الجزائر‬‎)","dz","213"],["American Samoa","as","1684"],["Andorra","ad","376"],["Angola","ao","244"],["Anguilla","ai","1264"],["Antigua and Barbuda","ag","1268"],["Argentina","ar","54"],["Armenia (Հայաստան)","am","374"],["Aruba","aw","297"],["Australia","au","61"],["Austria (Österreich)","at","43"],["Azerbaijan (Azərbaycan)","az","994"],["Bahamas","bs","1242"],["Bahrain (‫البحرين‬‎)","bh","973"],["Bangladesh (বাংলাদেশ)","bd","880"],["Barbados","bb","1246"],["Belarus (Беларусь)","by","375"],["Belgium (België)","be","32"],["Belize","bz","501"],["Benin (Bénin)","bj","229"],["Bermuda","bm","1441"],["Bhutan (འབྲུག)","bt","975"],["Bolivia","bo","591"],["Bosnia and Herzegovina (Босна и Херцеговина)","ba","387"],["Botswana","bw","267"],["Brazil (Brasil)","br","55"],["British Indian Ocean Territory","io","246"],["British Virgin Islands","vg","1284"],["Brunei","bn","673"],["Bulgaria (България)","bg","359"],["Burkina Faso","bf","226"],["Burundi (Uburundi)","bi","257"],["Cambodia (កម្ពុជា)","kh","855"],["Cameroon (Cameroun)","cm","237"],["Canada","ca","1",1,["204","236","249","250","289","306","343","365","387","403","416","418","431","437","438","450","506","514","519","548","579","581","587","604","613","639","647","672","705","709","742","778","780","782","807","819","825","867","873","902","905"]],["Cape Verde (Kabu Verdi)","cv","238"],["Caribbean Netherlands","bq","599",1],["Cayman Islands","ky","1345"],["Central African Republic (République centrafricaine)","cf","236"],["Chad (Tchad)","td","235"],["Chile","cl","56"],["China (中国)","cn","86"],["Colombia","co","57"],["Comoros (‫جزر القمر‬‎)","km","269"],["Congo (DRC) (Jamhuri ya Kidemokrasia ya Kongo)","cd","243"],["Congo (Republic) (Congo-Brazzaville)","cg","242"],["Cook Islands","ck","682"],["Costa Rica","cr","506"],["Côte d’Ivoire","ci","225"],["Croatia (Hrvatska)","hr","385"],["Cuba","cu","53"],["Curaçao","cw","599",0],["Cyprus (Κύπρος)","cy","357"],["Czech Republic (Česká republika)","cz","420"],["Denmark (Danmark)","dk","45"],["Djibouti","dj","253"],["Dominica","dm","1767"],["Dominican Republic (República Dominicana)","do","1",2,["809","829","849"]],["Ecuador","ec","593"],["Egypt (‫مصر‬‎)","eg","20"],["El Salvador","sv","503"],["Equatorial Guinea (Guinea Ecuatorial)","gq","240"],["Eritrea","er","291"],["Estonia (Eesti)","ee","372"],["Ethiopia","et","251"],["Falkland Islands (Islas Malvinas)","fk","500"],["Faroe Islands (Føroyar)","fo","298"],["Fiji","fj","679"],["Finland (Suomi)","fi","358"],["France","fr","33"],["French Guiana (Guyane française)","gf","594"],["French Polynesia (Polynésie française)","pf","689"],["Gabon","ga","241"],["Gambia","gm","220"],["Georgia (საქართველო)","ge","995"],["Germany (Deutschland)","de","49"],["Ghana (Gaana)","gh","233"],["Gibraltar","gi","350"],["Greece (Ελλάδα)","gr","30"],["Greenland (Kalaallit Nunaat)","gl","299"],["Grenada","gd","1473"],["Guadeloupe","gp","590",0],["Guam","gu","1671"],["Guatemala","gt","502"],["Guinea (Guinée)","gn","224"],["Guinea-Bissau (Guiné Bissau)","gw","245"],["Guyana","gy","592"],["Haiti","ht","509"],["Honduras","hn","504"],["Hong Kong (香港)","hk","852"],["Hungary (Magyarország)","hu","36"],["Iceland (Ísland)","is","354"],["India (भारत)","in","91"],["Indonesia","id","62"],["Iran (‫ایران‬‎)","ir","98"],["Iraq (‫العراق‬‎)","iq","964"],["Ireland","ie","353"],["Israel (‫ישראל‬‎)","il","972"],["Italy (Italia)","it","39",0],["Jamaica","jm","1876"],["Japan (日本)","jp","81"],["Jordan (‫الأردن‬‎)","jo","962"],["Kazakhstan (Казахстан)","kz","7",1],["Kenya","ke","254"],["Kiribati","ki","686"],["Kuwait (‫الكويت‬‎)","kw","965"],["Kyrgyzstan (Кыргызстан)","kg","996"],["Laos (ລາວ)","la","856"],["Latvia (Latvija)","lv","371"],["Lebanon (‫لبنان‬‎)","lb","961"],["Lesotho","ls","266"],["Liberia","lr","231"],["Libya (‫ليبيا‬‎)","ly","218"],["Liechtenstein","li","423"],["Lithuania (Lietuva)","lt","370"],["Luxembourg","lu","352"],["Macau (澳門)","mo","853"],["Macedonia (FYROM) (Македонија)","mk","389"],["Madagascar (Madagasikara)","mg","261"],["Malawi","mw","265"],["Malaysia","my","60"],["Maldives","mv","960"],["Mali","ml","223"],["Malta","mt","356"],["Marshall Islands","mh","692"],["Martinique","mq","596"],["Mauritania (‫موريتانيا‬‎)","mr","222"],["Mauritius (Moris)","mu","230"],["Mexico (México)","mx","52"],["Micronesia","fm","691"],["Moldova (Republica Moldova)","md","373"],["Monaco","mc","377"],["Mongolia (Монгол)","mn","976"],["Montenegro (Crna Gora)","me","382"],["Montserrat","ms","1664"],["Morocco (‫المغرب‬‎)","ma","212"],["Mozambique (Moçambique)","mz","258"],["Myanmar (Burma) (မြန်မာ)","mm","95"],["Namibia (Namibië)","na","264"],["Nauru","nr","674"],["Nepal (नेपाल)","np","977"],["Netherlands (Nederland)","nl","31"],["New Caledonia (Nouvelle-Calédonie)","nc","687"],["New Zealand","nz","64"],["Nicaragua","ni","505"],["Niger (Nijar)","ne","227"],["Nigeria","ng","234"],["Niue","nu","683"],["Norfolk Island","nf","672"],["North Korea (조선 민주주의 인민 공화국)","kp","850"],["Northern Mariana Islands","mp","1670"],["Norway (Norge)","no","47"],["Oman (‫عُمان‬‎)","om","968"],["Pakistan (‫پاکستان‬‎)","pk","92"],["Palau","pw","680"],["Palestine (‫فلسطين‬‎)","ps","970"],["Panama (Panamá)","pa","507"],["Papua New Guinea","pg","675"],["Paraguay","py","595"],["Peru (Perú)","pe","51"],["Philippines","ph","63"],["Poland (Polska)","pl","48"],["Portugal","pt","351"],["Puerto Rico","pr","1",3,["787","939"]],["Qatar (‫قطر‬‎)","qa","974"],["Réunion (La Réunion)","re","262"],["Romania (România)","ro","40"],["Russia (Россия)","ru","7",0],["Rwanda","rw","250"],["Saint Barthélemy (Saint-Barthélemy)","bl","590",1],["Saint Helena","sh","290"],["Saint Kitts and Nevis","kn","1869"],["Saint Lucia","lc","1758"],["Saint Martin (Saint-Martin (partie française))","mf","590",2],["Saint Pierre and Miquelon (Saint-Pierre-et-Miquelon)","pm","508"],["Saint Vincent and the Grenadines","vc","1784"],["Samoa","ws","685"],["San Marino","sm","378"],["São Tomé and Príncipe (São Tomé e Príncipe)","st","239"],["Saudi Arabia (‫المملكة العربية السعودية‬‎)","sa","966"],["Senegal (Sénégal)","sn","221"],["Serbia (Србија)","rs","381"],["Seychelles","sc","248"],["Sierra Leone","sl","232"],["Singapore","sg","65"],["Sint Maarten","sx","1721"],["Slovakia (Slovensko)","sk","421"],["Slovenia (Slovenija)","si","386"],["Solomon Islands","sb","677"],["Somalia (Soomaaliya)","so","252"],["South Africa","za","27"],["South Korea (대한민국)","kr","82"],["South Sudan (‫جنوب السودان‬‎)","ss","211"],["Spain (España)","es","34"],["Sri Lanka (ශ්‍රී ලංකාව)","lk","94"],["Sudan (‫السودان‬‎)","sd","249"],["Suriname","sr","597"],["Swaziland","sz","268"],["Sweden (Sverige)","se","46"],["Switzerland (Schweiz)","ch","41"],["Syria (‫سوريا‬‎)","sy","963"],["Taiwan (台灣)","tw","886"],["Tajikistan","tj","992"],["Tanzania","tz","255"],["Thailand (ไทย)","th","66"],["Timor-Leste","tl","670"],["Togo","tg","228"],["Tokelau","tk","690"],["Tonga","to","676"],["Trinidad and Tobago","tt","1868"],["Tunisia (‫تونس‬‎)","tn","216"],["Turkey (Türkiye)","tr","90"],["Turkmenistan","tm","993"],["Turks and Caicos Islands","tc","1649"],["Tuvalu","tv","688"],["U.S. Virgin Islands","vi","1340"],["Uganda","ug","256"],["Ukraine (Україна)","ua","380"],["United Arab Emirates (‫الإمارات العربية المتحدة‬‎)","ae","971"],["United Kingdom","gb","44"],["United States","us","1",0],["Uruguay","uy","598"],["Uzbekistan (Oʻzbekiston)","uz","998"],["Vanuatu","vu","678"],["Vatican City (Città del Vaticano)","va","39",1],["Venezuela","ve","58"],["Vietnam (Việt Nam)","vn","84"],["Wallis and Futuna","wf","681"],["Yemen (‫اليمن‬‎)","ye","967"],["Zambia","zm","260"],["Zimbabwe","zw","263"]],l=0;l<k.length;l++){var m=k[l];k[l]={name:m[0],iso2:m[1],dialCode:m[2],priority:m[3]||0,areaCodes:m[4]||null}}});